const userModel = require("../models/userModel");
const bcrypt = require("bcrypt");

const signup = async (req) => {
    const newUser = new userModel(req.body);
    const hash = await bcrypt.hash(req.body.password, 10);
    newUser.password = hash;
    const result = await newUser.save();
    return result;
};

const getUser = async (req) => {
    const { email } = req.body;
    const user = await userModel.findOne({email: email});
    return user
};

const getUserById = async (req) => {
    const { userId } = req.query;
    console.log("first :", req.query.userId);
    const user = await userModel.findById(userId).select("-password");
    return user;
};

const getUserData = async (req) => {
    const { userId } = req.body;
    const user = await userModel.findById(userId).select("-password");
    return user;
};

const updateUser = async (req) => {
    const { userId } = req.body;
    const updatedData = req.body;

    if(req.body.longitude && req.body.latitude){
        updatedData.location = {
            type: "Point",
            coordinates: [ parseFloat(req.body.longitude), parseFloat(req.body.latitude) ],
            locationName: req.body.locationName || null
        }
    };

    if(req.file && req.file.filename){
        updatedData.profileImage = req.file.filename
    };
    updatedData.isCreated = true
    const user = await userModel.findByIdAndUpdate(userId, 
        { $set: updatedData, },
        { new: true }
    ).select("-password");
    return user
};

const getNearbyUsers = async (req) => {
    const { userId, latitude, longitude } = req.query;

    const location = {
        type: "Point",
        coordinates: [ parseFloat(longitude), parseFloat(latitude) ],
    };

    const user = await userModel.find({
        _id: { $nin: [userId] },
        location:{
            $near:{
                $geometry: {
                    type: "Point",
                    coordinates: location.coordinates
                },
                $maxDistance: 100000
            }
        }
    });
    return user
};

const changePassword = async (req) => {
    const { userId, newPassword } = req.body;
    
    const hash = await bcrypt.hash(newPassword, 10);

    const user = await userModel.findByIdAndUpdate(userId, 
        { $set: { password: hash }},
        { new: true }
    );

    return user

};

const deleteUser = async (req) => {
    const { userId } = req.body;
    const user = await userModel.findByIdAndDelete(userId);
    return user;
};

module.exports = {
    signup,
    getUser,
    getUserById,
    getUserData,
    updateUser,
    getNearbyUsers,
    changePassword,
    deleteUser
};