const mongoose = require("mongoose");
const Schema = mongoose.Schema;

const reviewSchema = new Schema(
  {
    userId: {
      type: Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    placeId: {
      type: String,
    },
    restaurantName: {
      type: String,
    },
    address: {
      type: String,
    },
    rating: {
      type: Number,
    },
    reviewText: {
      type: String,
    },
    actionType: {
      type: String,
      enum: ["Go Again", "Avoid"],
    },
    photos: {
      type: [String],
      default: [],
    },
    coordinates: {
      latitude: { type: Number },
      longitude: { type: Number },
    },
  },
  { timestamps: true }
);

const Review = mongoose.model("Review", reviewSchema);
module.exports = Review;
