const express = require("express");
const router = express.Router();

const authController = require("../middleware/auth");
const userController = require("../controller/user");

router.post("/user/signup", userController.signup);
router.post("/user/login", userController.login);
router.get("/user/getUser", userController.getUserById);
router.post(
  "/user/updateUser",
  authController.uploadUser.single("profileImage"),
  userController.updateUser
);
router.get("/user/nearbyUsers", userController.nearbyUsers);
router.post("/user/forgetPassword", userController.forgetPassword);
router.post("/user/verifyOTP", userController.verifyOTP);
router.post("/user/resetPassword", userController.resetPassword);
router.post("/user/changePassword", userController.changePassword);
router.post("/user/deleteUser", userController.deleteUser);
router.post(
  "/user/addReview",
  authController.verifyUser,
  userController.addReview
);
router.get(
  "/user/reviews",
  authController.verifyUser,
  userController.getReview
);

module.exports = router;
